function Adj_reduced = transitive_reduction(Adj)

% Get the number of nodes
n = size(Adj, 1);

% Initialize the reduced adjacency matrix to be the same as the original
Adj_reduced = Adj;

% Loop over all nodes
for i = 1:n
    % Loop over all neighbors of node i
    for j = find(Adj(i, :))
        % Loop over all neighbors of node j
        for k = find(Adj(j, :))
            % If there is an edge from i to k, remove the edge from i to j
            if Adj(i, k)
                Adj_reduced(i, k) = 0;
                break;
            end
        end
    end
end

end
